function mat=translation(obj1,obj2)
% TRANSLATION retourne la matrice de translation d'un objet informatique marche 1
%    un objet informatique marche 2. Il s'agit prcisment d'une matrice relative
%    une zone d'nergie potentielle constante.
%   mat=TRANSLATION(obj1,obj2)
%       >> obj1 = objet informatique marche 1;
%       >> obj2 = objet informatique marche 2;
%       << mat  = matrice de translation de la marche 1  la marche 2.
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if ( (isa(obj1,'marche')==0) || (isa(obj2,'marche')==0) ),error('Mauvais type d''objet informatique !');end
if ( (obj2.ke==0)||(obj1.ks==0) ),error('Cas singulier k=0 !');end

%% Calcul de mat

mat=eye(2);
L=obj2.x-obj1.x;
k0=obj1.ks;
mat(1,1)=exp(i*k0*L);
mat(2,2)=exp(-i*k0*L);
%
return;